/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.test.drawable.ScrollThumbDrawable;
import icyllis.modernui.view.MotionEvent;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewConfig;
import icyllis.modernui.widget.FrameLayout;
import icyllis.modernui.widget.ScrollController;
import javax.annotation.Nonnull;

public class ScrollView
extends FrameLayout
implements ScrollController.IListener {
    private int scrollRange;
    private int scrollAmount;
    private final ScrollController scrollController = new ScrollController(this);

    public ScrollView() {
        this.setVerticalScrollBarEnabled(true);
        View.ScrollBar bar = new View.ScrollBar(this);
        bar.setThumbDrawable(new ScrollThumbDrawable());
        bar.setTrackDrawable(new Drawable(){

            @Override
            public void draw(@Nonnull Canvas canvas) {
                Paint paint = Paint.take();
                paint.reset();
                paint.setFeatherRadius(0.0f);
                paint.setRGBA(16, 16, 16, 40);
                canvas.drawRect(0.0f, 0.0f, this.getWidth(), this.getHeight(), paint);
            }
        });
        this.setVerticalScrollBar(bar);
    }

    @Override
    public float getScrollY() {
        return this.scrollAmount;
    }

    @Override
    protected void dispatchDraw(@Nonnull Canvas canvas) {
        this.scrollController.update(canvas.getDrawingTime());
        canvas.clipVertical(this);
        super.dispatchDraw(canvas);
        canvas.clipEnd();
    }

    @Override
    protected void onLayout(boolean changed) {
        super.onLayout(changed);
        this.scrollRange = this.getScrollRange();
        this.scrollController.setMaxScroll(this.scrollRange);
        if (this.getVerticalScrollBar() != null) {
            this.getVerticalScrollBar().setParameters(this.scrollRange, this.scrollAmount, this.getHeight());
        }
    }

    private int getScrollRange() {
        int scrollRange = 0;
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            scrollRange = Math.max(0, child.getHeight() - this.getHeight());
        }
        return scrollRange;
    }

    @Override
    protected boolean onMouseScrolled(double mouseX, double mouseY, double amount) {
        this.scrollController.scrollBy(Math.round(amount * -20.0));
        return true;
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent event) {
        if (event.getAction() == 8) {
            float delta = event.getAxisValue(9);
            return this.scrollController.scrollBy(Math.round(delta * -60.0f * ViewConfig.sViewScale));
        }
        return super.onGenericMotionEvent(event);
    }

    @Override
    protected void onScrollBarClicked(boolean vertical, float scrollDelta) {
        this.scrollController.scrollBy(scrollDelta);
    }

    @Override
    protected void onScrollBarDragged(boolean vertical, float scrollDelta) {
        this.scrollController.scrollBy(scrollDelta);
        this.scrollController.abortAnimation();
    }

    @Override
    public void onScrollAmountUpdated(ScrollController controller, float amount) {
        this.scrollAmount = (int)amount;
        if (this.getVerticalScrollBar() != null) {
            this.getVerticalScrollBar().setParameters(this.scrollRange, this.scrollAmount, this.getHeight());
        }
    }
}

